<?php
/**
 * @version	    1.1
 * @package		JPlugin
 * @subpackage	User
 * @copyright	Scouting Nederland 2011, All rights reserved
 * @license		GNU/GPL, see LICENSE.php
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

/**
 * Plugin that redirects a user to a custom, external logout page
 *
 * @author      Frits Zwegers
 * @package		JPlugin
 * @subpackage	System
 */
class plgUserLogout extends JPlugin {

    /**
     * Stores the username when the plugin is created
     * @var string
     */
    private $_username;

    /**
     * @param object $subject The object to observe
     * @param array $config  An array that holds the plugin configuration
     */
    public function __construct(&$subject, $config) {
        parent::__construct($subject, $config);
        $this->_username = JFactory::getUser()->username;
    }


    /**
     * Redirects to the logout page of the openid provider
     * When returning to the same (logout) page, the extension detects that it already performed redirect and skips.
     * @param array $credentials
     * @param array $options
     */
    function onUserLogout($credentials, $options) {
        $session = JFactory::getSession();
        if ($session->get('redirectProvider', false, 'userlogout') == $this->_username) {
            //Logout was already done
            $session->clear('redirectProvider', 'userlogout');
            return true; //Continue logout
        }

        $application = JFactory::getApplication();

        if ($application->isAdmin() || $credentials['username'] != $this->_username) {
            return true; //Skip admin site redirect
        }
        $session->set('redirectProvider', $credentials['username'], 'userlogout');
        $return = (array_key_exists('return', $options) ? base64_decode($options['return']) : JURI::base());
        $form_html = $this->_generateLogoutRedirectForm($this->params->get('logout_url'), 'openid_return_url', $return, $this->_username);
        $application->setBody($form_html);
        $mainframe = JFactory::getApplication();
        echo $application->toString($mainframe->get('gzip'));
        $mainframe->close();
    }

    /**
     * Generates a logout form for the openid provider
     * @param string $url
     * @param string $return_url
     */
    protected function _generateLogoutRedirectForm($url, $return_param, $return_url, $username) {
        return include 'plg_user_logout.phtml';
    }
}
