<?php
require_once "Auth/OpenID/MySQLStore.php";

class openid_DB_STORE_MySQL extends Auth_OpenID_MySQLStore
{

    function setSQL()
    {
        parent::setSQL();
        $this->sql['set_assoc'] = "REPLACE INTO %s (server_url, handle, secret, issued,\n" .
        "  lifetime, assoc_type) VALUES (?, ?, ?, ?, ?, ?)";
    }

    function blobEncode($str)
    {
        return $str;
    }

    function isError($value)
    {
        return !(bool)$value;
    }

    //PHP 7 compatible version (list reversed)
    function getAssociation($server_url, $handle = null)
    {
        if ($handle !== null) {
            $assoc = $this->_get_assoc($server_url, $handle);

            $assocs = array();
            if ($assoc) {
                $assocs[] = $assoc;
            }
        } else {
            $assocs = $this->_get_assocs($server_url);
        }

        if (!$assocs || (count($assocs) == 0)) {
            return null;
        } else {
            $associations = array();

            foreach ($assocs as $assoc_row) {
                $assoc = new Auth_OpenID_Association($assoc_row['handle'],
                    $assoc_row['secret'],
                    $assoc_row['issued'],
                    $assoc_row['lifetime'],
                    $assoc_row['assoc_type']);

                $assoc->secret = $this->blobDecode($assoc->secret);

                if ($assoc->getExpiresIn() == 0) {
                    $this->removeAssociation($server_url, $assoc->handle);
                } else {
                    $associations[] = array($assoc->issued,  $assoc);
                }
            }

            if ($associations) {
                $issued = array();
                $assocs = array();
                foreach ($associations as $key => $assoc) {
                    $issued[$key] = $assoc[0];
                    $assocs[$key] = $assoc[1];
                }

                array_multisort($issued, SORT_DESC, $assocs, SORT_DESC,
                    $associations);

                // return the most recently issued one.
                if (version_compare(PHP_VERSION, '7.0.0') >= 0) {
                    list($assoc) = array_reverse($associations[0]);
                } else {
                   $assoc = $associations[0][1];
                }

                return $assoc;
            } else {
                return null;
            }
        }
    }

}