<?php
require_once 'Auth/OpenID/Extension.php';

/**
 * Adds a custom Scouting extension to the request to select a theme
 * @author fzw
 */
class openidThemeExtension extends Auth_OpenID_Extension {

    const NS = 'https://login.scouting.nl/ns/theme/1.0';

    /**
     * Selected theme
     * @var string
     */
    private $theme;

    public function __construct($theme) {
        $this->ns_uri = self::NS;
        $this->ns_alias = 'theme';
        $this->theme = $theme;
    }

    public function getExtensionArgs($request = NULL) {
        return array('theme' => $this->theme);
    }
}