<?php
/**
 * @version	    1.0
 * @package		JPlugin
 * @subpackage	System
 * @copyright	Scouting Nederland 2011, All rights reserved
 * @license		GNU/GPL, see LICENSE.php
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

/**
 * Plugin that redirects the user to the page he started login when usingOpenID login
 *
 * @author      Frits Zwegers
 * @package		JPlugin
 * @subpackage	System
 */
class plgSystemReturnAfterLogin extends JPlugin {

    public function onBeforeRender() {
        $application = JFactory::getApplication();
        $result = $application->getUserState('login_return_url');
        if ($result === null) {
            return; //No redirect url found
        }
        $application->setUserState('login_return_url', null);
        if ($application->isAdmin()) {
            return; //Skip admin site redirect
        }
        $application->redirect($result);
    }
}
